% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program SATfull_costfunc.m
function L = SATfull_costfunc(guess, data)

NSATs = size(data, 1)/2;
Ndelays = size(data, 2);
lamda= guess(1:NSATs);
beta = guess((NSATs+1):(2*NSATs));
delta = guess((2*NSATs+1):(3*NSATs));

L=0;
for i = 1:NSATs
    t = data((i-1)*2+1, :);
    Observed_dp = data((i-1)*2+2, :);
    Predicted_dp = lamda(i) .* ( 1 - exp(-beta(i) ...
        * ( t - delta(i) ) ) );
    L = L+sum ((Observed_dp - Predicted_dp).^2);
end
